"""    PROGRAMMONE    """
#
#
import pandas as pd
import numpy as np
import os
import logging
from datetime import datetime
from scelte_run import scelte
from pre_processing import preprocessing
from analisi_outliers_IQR import analizza_outliers
from divisione_dataset import divisione
from aggregazione_tiles import aggregazione
from feature_selection_originale import fe_se
from training_validation_test import esegui_classificatori_per_feature_selection_da_cartella
from aggiunta_label import aggiunta_classi
from metodo_PCA import PCA_metodo_e_train
#

def trova_file_set(path_divisione, prefisso):
    """
    Cerca e restituisce i path dei file media/stats per training, validation e test 
    di un certo prefisso (es. 'F' o 'I').
    
    Parameters:
    - path_divisione: directory dove cercare i file
    - prefisso: 'F' o 'I' (o altro prefisso usato nei nomi dei file)
    
    Returns:
    - dict con i path trovati, ad esempio:
      {
          'media_training': ...,
          'stats_training': ...,
          'media_validation': ...,
          'stats_validation': ...,
          'media_test': ...,
          'stats_test': ...
      }
    """
    path_dict = {
        'media_training': None,
        'stats_training': None,
        'media_validation': None,
        'stats_validation': None,
        'media_test': None,
        'stats_test': None
    }

    for file in os.listdir(path_divisione):
        file_path = os.path.join(path_divisione, file)

        if file.endswith(f'media_{prefisso}_training_set.csv'):
            path_dict['media_training'] = file_path
        elif file.endswith(f'stats_{prefisso}_training_set.csv'):
            path_dict['stats_training'] = file_path
        elif file.endswith(f'media_{prefisso}_validation_set.csv'):
            path_dict['media_validation'] = file_path
        elif file.endswith(f'stats_{prefisso}_validation_set.csv'):
            path_dict['stats_validation'] = file_path
        elif file.endswith(f'media_{prefisso}_test_set.csv'):
            path_dict['media_test'] = file_path
        elif file.endswith(f'stats_{prefisso}_test_set.csv'):
            path_dict['stats_test'] = file_path

    # Verifica che siano stati trovati tutti i file
    if any(v is None for v in path_dict.values()):
        print(f"\n Alcuni file mancanti nel path: {path_divisione}")
        for k, v in path_dict.items():
            if v is None:
                print(f" - Manca: {k}")
        print("Verifica di aver eseguito prima la divisione dei dataset.\n")
        exit()
    #
    return path_dict
        
def main(path_pazienti, path_pazienti_preprocessing):
    #
    #   ===== PARTE 0: SCELTA DEI BLOCCHI DA COMPUTARE =====
    #
    if not os.path.exists(path_pazienti):
        print(f"Errore: la cartella {path_pazienti} non esiste. Controlla il percorso.")
        return
    #
    # creo una nuova cartella di contenimento per tutti i dati processati se non esiste già
    os.makedirs(path_pazienti_preprocessing, exist_ok=True)
    # creo le sotto cartelle in cui salvare i risultati
    path_dataset_F = os.path.join(path_pazienti_preprocessing, "Dataset F")
    path_dataset_I = os.path.join(path_pazienti_preprocessing, "Dataset I")
    path_divisione_F = os.path.join(path_dataset_F,"dataset divisi")
    path_risultati_feature_selection_F = os.path.join(path_dataset_F,"risultati feature selection")
    path_risultati_classificatori_F = os.path.join(path_dataset_F,"risultati classficatori")
    path_divisione_I = os.path.join(path_dataset_I,"dataset divisi")
    path_risultati_feature_selection_I = os.path.join(path_dataset_I,"risultati feature selection")
    path_risultati_classificatori_I = os.path.join(path_dataset_I,"risultati classficatori")
    path_dataset_F_media = os.path.join(path_risultati_feature_selection_F,"fet_sel_media")
    path_dataset_F_stats = os.path.join(path_risultati_feature_selection_F,"fet_sel_stats")
    path_dataset_I_media = os.path.join(path_risultati_feature_selection_I,"fet_sel_media")
    path_dataset_I_stats = os.path.join(path_risultati_feature_selection_I,"fet_sel_stats")
    PCA_F = os.path.join(path_dataset_F,"PCA")
    PCA_I = os.path.join(path_dataset_I,"PCA")
    PCA_F_media = os.path.join(PCA_F,"PCA_media")
    PCA_F_stats = os.path.join(PCA_F,"PCA_stats")
    PCA_I_media = os.path.join(PCA_I,"PCA_media")
    PCA_I_stats = os.path.join(PCA_I,"PCA_stats")
    label_path = "C:\\Users\\Tullio\\Desktop\\TESIDASTUDIARE\\Pazienti_classificazioni.xlsx"
    # Crea una cartella per i log se non esiste
    log_dir = os.path.join(path_pazienti_preprocessing,'logs')
    os.makedirs(log_dir, exist_ok=True)
    os.makedirs(path_dataset_F, exist_ok=True)
    os.makedirs(path_dataset_I, exist_ok=True)
    os.makedirs(path_divisione_F, exist_ok=True)
    os.makedirs(path_risultati_feature_selection_F, exist_ok=True)
    os.makedirs(path_risultati_classificatori_F, exist_ok=True)
    os.makedirs(path_divisione_I, exist_ok=True)
    os.makedirs(path_risultati_feature_selection_I, exist_ok=True)
    os.makedirs(path_risultati_classificatori_I, exist_ok=True)
    os.makedirs(path_dataset_F_media,exist_ok=True)
    os.makedirs(path_dataset_F_stats,exist_ok=True)
    os.makedirs(path_dataset_I_media,exist_ok=True)
    os.makedirs(path_dataset_I_stats,exist_ok=True)
    os.makedirs(PCA_F,exist_ok=True)
    os.makedirs(PCA_I,exist_ok=True)
    os.makedirs(PCA_F_media,exist_ok=True)
    os.makedirs(PCA_F_stats,exist_ok=True)
    os.makedirs(PCA_I_media,exist_ok=True)
    os.makedirs(PCA_I_stats,exist_ok=True)
    
    # configurazione dei file di log
    # Nome file con data e ora
    log_filename = os.path.join(log_dir, datetime.now().strftime("log_%Y-%m-%d_%H-%M-%S.log"))
    

    # Configurazione base del logging
    logging.basicConfig(
        filename=log_filename,
        level=logging.INFO,
        format='%(asctime)s - %(levelname)s - %(message)s'
        )

    # Scrive anche a schermo (non solo su file)
    console = logging.StreamHandler()
    console.setLevel(logging.INFO)
    formatter = logging.Formatter('%(asctime)s - %(levelname)s - %(message)s')
    console.setFormatter(formatter)
    logging.getLogger().addHandler(console)

    # sottoprogramma per la scelta di come eseguire il main() se a moduli o intero
    
    do_preprocessing, do_divisione, do_feature_selection, do_training_test, do_PCA = scelte()
    
    
    if do_preprocessing:
        #
        #   ===== PARTE 1: PREPROCESSING DEL DATASET =====
        #
        try:
            # pulisco i pazienti e li divido in F e I
            path_dataset_F_singoli, path_dataset_I_singoli = preprocessing(path_pazienti, path_pazienti_preprocessing)
            #
        except Exception as e:
            logging.exception(f"Errore nel processo di pulizia e divisione")
            return
        
        # analizzo outliers
        output_dir = os.path.join(path_pazienti_preprocessing,"analisi_outliers")
        
        try:   
            # calcolo % outliers identificati di ogni feature per ogni paziente dei due dataset
            analizza_outliers(path_dataset_F_singoli, path_dataset_I_singoli, output_dir)
        
        except Exception as e:
            logging.exception(f"Errore nel calcolo degli outliers")
            return

        output_F_agg = os.path.join(path_dataset_F, "Dataset aggregati") 
        output_I_agg = os.path.join(path_dataset_I, "Dataset aggregati")   
        os.makedirs(output_F_agg, exist_ok=True)
        os.makedirs(output_I_agg, exist_ok=True)

        # ====== AGGREGAZIONE PAZIENTI ======
        try:
            # aggregazione feature in due dataframe 
            # dataset F
            df_media_F_path, df_stats_F_path = aggregazione(path_dataset_F_singoli, output_F_agg)
            # dataset I
            df_media_I_path, df_stats_I_path = aggregazione(path_dataset_I_singoli, output_I_agg)
            
        except Exception as e:
            logging.exception(f"Errore nel processo di aggregazione delle tiles")
        
        # ====== AGGIUNTA CLASSI AI PAZIENTI CHE NE HANNO UNA ======
        
        media_F_label, stats_F_label, media_I_label, stats_I_label, label_df = (None, None, None, None, None)
        # leggo file delle classi nel caso in cui non è definito
        # label_path = input("Si prega l'utente di intesrire il percorso(path) del file delle classi: \n")
        try:
            if label_path.endswith(".csv"):
                label_df = pd.read_csv(label_path)
            elif label_path.endswith(".xlsx") or label_path.endswith(".xls"):
                label_df = pd.read_excel(label_path)
        except Exception as e:
            print(f"Errore nel caricamento del file delle classi")
        if label_df is None:
            print("Programma interrotto per mancato caricamento file classi.")
            return
            
        # aggiungo classi al dataset F
        try:
            media_F_label, stats_F_label = aggiunta_classi(
                df_media_F_path, df_stats_F_path, label_df, path_dataset_F
                )
        except Exception as e:
            print(f"Errore nel processo di agiunta delle label")
        # aggiungo classi al dataset I    
        try:
            media_I_label, stats_I_label = aggiunta_classi(
                df_media_I_path, df_stats_I_path, label_df, path_dataset_I
                )
        except Exception as e:
            logging.exception(f"Errore nel processo di agiunta delle label")
            
        print("Preprocessing Done!")
        
    if do_divisione:
        #
        #   ===== DIVISIONE DEI DATASET AGGREGATI IN TRAINING-VALIDATION E TEST =====
        #
        # Percorsi ai file aggregati
        if not media_F_label:
            media_F_label = [os.path.join(path_dataset_F, f) for f in os.listdir(path_dataset_F)
                                    if f.endswith('media_label.csv')]
        if not stats_F_label:
            stats_F_label = [os.path.join(path_dataset_F, f) for f in os.listdir(path_dataset_F)
                                    if f.endswith('stats_label.csv')] 
        if not media_I_label:
            media_I_label = [os.path.join(path_dataset_I, f) for f in os.listdir(path_dataset_I)
                                    if f.endswith('media_label.csv')]
        if not stats_I_label:
            stats_I_label = [os.path.join(path_dataset_I, f) for f in os.listdir(path_dataset_I)
                                    if f.endswith('stats_label.csv')]
        
        try:
            training_mean_F_path, validation_mean_F_path, test_mean_F_path = divisione(media_F_label, path_divisione_F, "media_F")
            print("Divisione dataset_media_F completato!")
        except Exception as e:
            logging.exception(f"Errore nella divisione di media_F")
        try:
            training_stats_F_path, validation_stats_F_path, test_stats_F_path = divisione(stats_F_label, path_divisione_F, "stats_F")
            print("Divisione dataset_stats_F completato!")
        except Exception as e:
            logging.exception(f"Errore nella divisione di stats_F")
        try:
            training_mean_I_path, validation_mean_I_path, test_mean_I_path = divisione(media_I_label, path_divisione_I, "media_I")
            print("Divisione dataset_media_I completato!")
        except Exception as e:
            logging.exception(f"Errore nella divisione di media_I")
        try:
            training_stats_I_path, validation_stats_I_path, test_stats_I_path = divisione(stats_I_label, path_divisione_I, "stats_I")
            print("Divisione dataset_stts_I completato!")
        except Exception as e:
            logging.exception(f"Errore nella divisione di stats_I")
            
        print("Divisione del dataset avvenuta!")
        #
    if do_feature_selection:
        #
        #   =====   FEATURE SELECTION CON I VARI METODI ===== 
        #
        # controllo se i percorsi sono legati ai file altrimenti definisco i percorsi dei
        # file di input di questo blocco di feature selection
        
        # === Dataset F ===
        path_F = trova_file_set(path_divisione_F, 'F')
        training_mean_F_path = path_F['media_training']
        training_stats_F_path = path_F['stats_training']
        validation_mean_F_path = path_F['media_validation']
        validation_stats_F_path = path_F['stats_validation']
        test_mean_F_path = path_F['media_test']
        test_stats_F_path = path_F['stats_test']

        #
        try:
            print("Inizio feature selection - Media F \n")
            fe_se(training_mean_F_path, path_dataset_F_media)
            print("\n Finita feature selection - Media F \n")
        except Exception as e:
            logging.exception(f"Errore nella feature selection (media F)")
        try:
            print("Inizio feature selection - Statistiche F \n")
            fe_se(training_stats_F_path, path_dataset_F_stats)
            print("\n Finita feature selection - Statistiche F \n")
        except Exception as e:
            logging.exception(f"Errore nella feature selection (stats F)")
        
        """        # === Dataset I ===
        path_I = trova_file_set(path_divisione_I, 'I')
        training_mean_I_path = path_I['media_training']
        training_stats_I_path = path_I['stats_training']
        validation_mean_I_path = path_I['media_validation']
        validation_stats_I_path = path_I['stats_validation']
        test_mean_I_path = path_I['media_test']
        test_stats_I_path = path_I['stats_test']
        
        try:
            print("Inizio feature selection - Media I \n")
            fe_se(training_mean_I_path, path_dataset_I_media)
            print("\n Finita feature selection - Media I \n")
        except Exception as e:
            logging.exception(f"Errore nella feature selection (media I)")      
        try:
            print("Inizio feature selection - Statistiche I \n")
            fe_se(training_stats_I_path, path_dataset_I_stats)
            print("\n Finita feature selection - Statistiche F \n")
        except Exception as e:
            logging.exception(f"Errore nella feature selection (stats I)")"""

    if do_training_test:
        #
        # ====== PARTE 5 TRAINING DEI CLASSIFFICATORI CON VALIDATION E TEST ======
        
        # ========= dataset F ===========
        
        path_F = trova_file_set(path_divisione_F, 'F')
        training_mean_F_path = path_F['media_training']
        training_stats_F_path = path_F['stats_training']
        validation_mean_F_path = path_F['media_validation']
        validation_stats_F_path = path_F['stats_validation']
        test_mean_F_path = path_F['media_test']
        test_stats_F_path = path_F['stats_test']
        
        path_risultati_classificatori_F_media = os.path.join(path_risultati_classificatori_F,'risultati agg media')
        path_risultati_classificatori_F_stats = os.path.join(path_risultati_classificatori_F,'risultati agg stats')
        os.makedirs(path_risultati_classificatori_F_media, exist_ok=True)
        os.makedirs(path_risultati_classificatori_F_stats, exist_ok=True)
        
        
        try:
            esegui_classificatori_per_feature_selection_da_cartella(
                training_mean_F_path, validation_mean_F_path, test_mean_F_path,
                path_dataset_F_media, path_risultati_classificatori_F_media
                )
        except Exception as e:
            logging.exception(f"Errore nel processo di training-validation-test del dataset F media") 
        try:
            esegui_classificatori_per_feature_selection_da_cartella(
                training_stats_F_path, validation_stats_F_path, test_stats_F_path,
                path_dataset_F_stats, path_risultati_classificatori_F_stats
                )
        except Exception as e:
            logging.exception(f"Errore nel processo di training-validation-test del dataset F stats")  
        
        # ========== dataset I ============ 
     
        """path_I = trova_file_set(path_divisione_I, 'I')
        training_mean_I_path = path_I['media_training']
        training_stats_I_path = path_I['stats_training']
        validation_mean_I_path = path_I['media_validation']
        validation_stats_I_path = path_I['stats_validation']
        test_mean_I_path = path_I['media_test']
        test_stats_I_path = path_I['stats_test']
        
        path_risultati_classificatori_I_media = os.path.join(path_risultati_classificatori_I,'risultati agg media')
        path_risultati_classificatori_I_stats = os.path.join(path_risultati_classificatori_I,'risultati agg stats')
        os.makedirs(path_risultati_classificatori_I_media, exist_ok=True)
        os.makedirs(path_risultati_classificatori_I_stats, exist_ok=True)
        
        try:
            esegui_classificatori_per_feature_selection_da_cartella(
                training_mean_I_path, validation_mean_I_path, test_mean_I_path,
                path_dataset_I_media, path_risultati_classificatori_I_media
                )
        except Exception as e:
            logging.exception(f"Errore nel processo di training-validation-test del dataset I media") 
        try:
            esegui_classificatori_per_feature_selection_da_cartella(
                training_stats_I_path, validation_stats_I_path, test_stats_I_path,
                path_dataset_I_stats, path_risultati_classificatori_I_stats
                )
        except Exception as e:
            logging.exception(f"Errore nel processo di training-validation-test del dataset I stats")"""        
        
    if do_PCA:
        # metodo PCA e classificazione con class.ori lineari
        
        # ========= dataset F ===========
        
        path_F = trova_file_set(path_divisione_F, 'F')
        training_mean_F_path = path_F['media_training']
        training_stats_F_path = path_F['stats_training']
        validation_mean_F_path = path_F['media_validation']
        validation_stats_F_path = path_F['stats_validation']
        test_mean_F_path = path_F['media_test']
        test_stats_F_path = path_F['stats_test']
        
        try:
            PCA_metodo_e_train(
                training_mean_F_path, validation_mean_F_path, test_mean_F_path, 
                PCA_F_media)        
        except Exception as e:
            logging.exception(f"Errore nel processo di PCA del dataset F media")     
        try:
            PCA_metodo_e_train(
                training_stats_F_path, validation_stats_F_path, test_stats_F_path,
                PCA_F_stats)    
        except Exception as e:
            logging.exception(f"Errore nel processo di PCA del dataset F stats")  
        
        # ========== dataset I ============ 
     
        """path_I = trova_file_set(path_divisione_I, 'I')
        training_mean_I_path = path_I['media_training']
        training_stats_I_path = path_I['stats_training']
        validation_mean_I_path = path_I['media_validation']
        validation_stats_I_path = path_I['stats_validation']
        test_mean_I_path = path_I['media_test']
        test_stats_I_path = path_I['stats_test']
        
        try:
            PCA_metodo_e_train(training_mean_I_path, validation_mean_I_path, test_mean_I_path, 
                               PCA_I_media)    
        except Exception as e:
            logging.exception(f"Errore nel processo di PCA del dataset I media")     
        try:
            PCA_metodo_e_train(training_stats_I_path, validation_stats_I_path, test_stats_I_path, 
                               PCA_I_stats)    
        except Exception as e:
            logging.exception(f"Errore nel processo di PCA del dataset I stats") 
        print("Completamento parte di Training-Validation e Test")"""
    #
    #percorso_risultati = os.path.abspath(path_dataset_F)
    print("\n Il programma ha completato tutte le operazioni!")
    print(f"Puoi trovare i risultati qui: {path_pazienti_preprocessing}")

if __name__ == "__main__" :
    #
    path_pazienti = "C:\\Users\\Tullio\\Desktop\\TESIDASTUDIARE\\NO-CUT_alltiles"
    path_pazienti_preprocessing = "C:\\Users\\Tullio\\Desktop\\TESIDASTUDIARE\\NO-CUT_alltiles_cleaned"
    main(path_pazienti, path_pazienti_preprocessing)